<?php
// Include database connection
include 'db.php'; // Ensure this file contains `$conn`

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data)) {
    $successCount = 0;
    $errorCount = 0;

    foreach ($data as $item) {
        if (!isset($item['category_ID']) || !isset($item['position']) || empty($item['category_ID'])) {
            continue; // Skip empty or invalid entries
        }

        $catid = mysqli_real_escape_string($conn, $item['category_ID']);
        $position = mysqli_real_escape_string($conn, $item['position']);

        $sql = "UPDATE categories SET position = '$position' WHERE category_ID = '$catid'";
        
        if (mysqli_query($conn, $sql)) {
            $successCount++;
        } else {
            $errorCount++;
            error_log("Error updating category_ID $catid: " . mysqli_error($conn)); // Log error for debugging
        }
    }

    echo json_encode([
        "status" => "success",
        "updated" => $successCount,
        "failed" => $errorCount
    ]);
} else {
    echo json_encode(["status" => "error", "message" => "No valid data received"]);
}
?>
